
import React from 'react';
import Square from './Square';

interface BoardProps {
  squares: Array<'X' | 'O' | null>;
  onClick: (i: number) => void;
  winnerLine: number[] | null;
}

const Board: React.FC<BoardProps> = ({ squares, onClick, winnerLine }) => {
  const renderSquare = (i: number) => {
    return (
      <Square
        value={squares[i]}
        onClick={() => onClick(i)}
        isWinnerSquare={winnerLine?.includes(i) ?? false}
      />
    );
  };

  return (
    <div className="grid grid-cols-3 gap-1 p-2 bg-gray-900 rounded-lg">
      {Array(9).fill(null).map((_, i) => (
         <div key={i}>{renderSquare(i)}</div>
      ))}
    </div>
  );
};

export default Board;
