import type { User } from './types';

/**
 * A constant representing the Bot user for single-player games.
 */
export const BOT_USER: User = { id: 'bot-player', username: 'کامپیوتر' };

export const LUDO_PLAYER_COLORS: { [key: string]: { base: string, shadow: string, text: string } } = {
    player1: { // Red
        base: 'bg-red-500',
        shadow: 'hover:shadow-[0_0_15px_5px_rgba(239,68,68,0.7)]',
        text: 'text-red-400'
    },
    player2: { // Blue
        base: 'bg-blue-500',
        shadow: 'hover:shadow-[0_0_15px_5px_rgba(59,130,246,0.7)]',
        text: 'text-blue-400'
    },
     // In case we want to expand to 4 players later
    player3: { // Green
        base: 'bg-green-500',
        shadow: 'hover:shadow-[0_0_15px_5px_rgba(34,197,94,0.7)]',
        text: 'text-green-400'
    },
    player4: { // Yellow
        base: 'bg-yellow-500',
        shadow: 'hover:shadow-[0_0_15px_5px_rgba(234,179,8,0.7)]',
        text: 'text-yellow-400'
    }
};
