import React, { useState, useContext } from 'react';
import { useNavigate, Link } from 'react-router-dom';
import { AuthContext } from '../App';

const Register: React.FC = () => {
  const [username, setUsername] = useState('');
  const [password, setPassword] = useState('');
  const [confirmPassword, setConfirmPassword] = useState('');
  const [error, setError] = useState('');
  const navigate = useNavigate();
  const auth = useContext(AuthContext);

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault();
    if (password !== confirmPassword) {
      setError('رمزهای عبور مطابقت ندارند.');
      return;
    }
    if (!username || !password) {
        setError('لطفاً تمام فیلدها را پر کنید.');
        return;
    }

    const result = auth?.register(username, password);

    if (result?.success) {
      navigate('/games');
    } else {
      setError(result?.message || 'خطا در ثبت نام.');
    }
  };

  return (
     <div className="flex-grow flex items-center justify-center p-4 bg-gray-900">
      <div className="w-full max-w-md bg-gray-800 rounded-xl shadow-2xl p-8 border border-gray-700">
        <h2 className="text-3xl font-bold text-center text-white mb-8">ایجاد حساب کاربری جدید</h2>
        <form onSubmit={handleSubmit} className="space-y-6">
           {error && <p className="bg-red-500/20 text-red-400 p-3 rounded-md text-center">{error}</p>}
          <div>
            <label className="block text-sm font-medium text-gray-300 mb-2" htmlFor="username">نام کاربری</label>
            <input
              id="username"
              type="text"
              value={username}
              onChange={(e) => setUsername(e.target.value)}
              className="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-md text-white focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 outline-none"
              required
            />
          </div>
          <div>
            <label className="block text-sm font-medium text-gray-300 mb-2" htmlFor="password">رمز عبور</label>
            <input
              id="password"
              type="password"
              value={password}
              onChange={(e) => setPassword(e.target.value)}
              className="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-md text-white focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 outline-none"
              required
            />
          </div>
          <div>
            <label className="block text-sm font-medium text-gray-300 mb-2" htmlFor="confirmPassword">تکرار رمز عبور</label>
            <input
              id="confirmPassword"
              type="password"
              value={confirmPassword}
              onChange={(e) => setConfirmPassword(e.target.value)}
              className="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-md text-white focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 outline-none"
              required
            />
          </div>
          <button
            type="submit"
            className="w-full py-3 px-4 bg-indigo-600 hover:bg-indigo-700 rounded-md text-white font-semibold transition-colors shadow-lg"
          >
            ثبت نام
          </button>
        </form>
        <p className="text-center text-gray-400 mt-6">
          قبلاً ثبت نام کرده‌اید؟ <Link to="/login" className="text-indigo-400 hover:underline">وارد شوید</Link>
        </p>
      </div>
    </div>
  );
};

export default Register;